/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

final class PropertyMatches {
    public static final int DEFAULT_MAX_DISTANCE = 2;
    private final String propertyName;
    private String[] possibleMatches;

    public static PropertyMatches forProperty(String propertyName, Class beanClass) {
        return PropertyMatches.forProperty(propertyName, beanClass, 2);
    }

    public static PropertyMatches forProperty(String propertyName, Class beanClass, int maxDistance) {
        return new PropertyMatches(propertyName, beanClass, maxDistance);
    }

    private PropertyMatches(String propertyName, Class beanClass, int maxDistance) {
        this.propertyName = propertyName;
        this.possibleMatches = this.calculateMatches(BeanUtils.getPropertyDescriptors(beanClass), maxDistance);
    }

    public String[] getPossibleMatches() {
        return this.possibleMatches;
    }

    public String buildErrorMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Bean property '");
        msg.append(this.propertyName);
        msg.append("' is not writable or has an invalid setter method. ");
        if (ObjectUtils.isEmpty((Object[])this.possibleMatches)) {
            msg.append("Does the parameter type of the setter match the return type of the getter?");
        } else {
            msg.append("Did you mean ");
            int i = 0;
            while (i < this.possibleMatches.length) {
                msg.append('\'');
                msg.append(this.possibleMatches[i]);
                if (i < this.possibleMatches.length - 2) {
                    msg.append("', ");
                } else if (i == this.possibleMatches.length - 2) {
                    msg.append("', or ");
                }
                ++i;
            }
            msg.append("'?");
        }
        return msg.toString();
    }

    private String[] calculateMatches(PropertyDescriptor[] propertyDescriptors, int maxDistance) {
        ArrayList<String> candidates = new ArrayList<String>();
        PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleAlternative;
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getWriteMethod() != null && this.calculateStringDistance(this.propertyName, possibleAlternative = pd.getName()) <= maxDistance) {
                candidates.add(possibleAlternative);
            }
            ++n2;
        }
        Collections.sort(candidates);
        return StringUtils.toStringArray(candidates);
    }

    private int calculateStringDistance(String s1, String s2) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int[][] d = new int[s1.length() + 1][s2.length() + 1];
        int i = 0;
        while (i <= s1.length()) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= s2.length()) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= s1.length()) {
            char s_i = s1.charAt(i - 1);
            int j2 = 1;
            while (j2 <= s2.length()) {
                char t_j = s2.charAt(j2 - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j2] = Math.min(Math.min(d[i - 1][j2] + 1, d[i][j2 - 1] + 1), d[i - 1][j2 - 1] + cost);
                ++j2;
            }
            ++i;
        }
        return d[s1.length()][s2.length()];
    }
}

