// *********************************************
// TOUT CE QUI CONCERNE GOOGLE MAPS...
var com_jispot_map;
var com_jispot_markers_spot = new Array(); // an array keeping all markers in memory

/* ****************************** */
/* ******  MAP MANAGEMENT  ****** */
function initializeGMaps(lat, lng) {
  if (com_jispot_DEBUG >= 3) alert('>>> initializeGMaps');
  var latlng = new google.maps.LatLng(lat, lng);
  var myOptions = {
    zoom : 12,
    center : latlng,
    mapTypeId : google.maps.MapTypeId.HYBRID,
    mapTypeControl: true,
    mapTypeControlOptions: {
        style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,
        position: google.maps.ControlPosition.TOP_LEFT
    },
    navigationControl: true,
    navigationControlOptions: {
        style: google.maps.NavigationControlStyle.ZOOM_PAN,
        position: google.maps.ControlPosition.RIGHT
    },
    scaleControl: true,
    scaleControlOptions: {
        position: google.maps.ControlPosition.BOTTOM_RIGHT
    }     
  }
  com_jispot_map = new google.maps.Map(document.getElementById('map_canvas'), myOptions);
  if (com_jispot_DEBUG >= 3) alert('<<< initializeGMaps');
}

function showForm(width) {
  $('#dynForm').css('width', width).show().fadeIn();
  triggerResizeMap();
}
function showMap() {
  $('#dynForm').css('width','0px').hide().fadeIn();
  triggerResizeMap();
}
function triggerResizeMap() {
  // trigger event to resize GoogleMaps content
  google.maps.event.trigger(com_jispot_map, 'resize');
}


/* ****************************** */
/* ****** SPOTS MANAGEMENT ****** */
function addSpotMarkers(marker) {
  if (com_jispot_DEBUG >= 3) alert('>>> addSpotMarkers');
  this.com_jispot_markers_spot[this.com_jispot_markers_spot.length] = marker;
  if (com_jispot_DEBUG >= 2) alert('addSpotMarkers : ' + this.com_jispot_markers_spot.length);
  if (com_jispot_DEBUG >= 3) alert('<<< addSpotMarkers');
}
function clearSpotMarkers() { 
  if (com_jispot_DEBUG >= 3) alert('>>> clearSpotMarkers');
  for(var i=0; i<com_jispot_markers_spot.length; i++){
    com_jispot_markers_spot[i].setMap(null);
  }
  com_jispot_markers_spot = new Array();
  if (com_jispot_DEBUG >= 3) alert('<<< clearSpotMarkers');
}
function showSpotMarkers() { 
  if (com_jispot_DEBUG >= 3) alert('>>> showSpotMarkers');
  for(var i=0; i<com_jispot_markers_spot.length; i++){
    com_jispot_markers_spot[i].setVisible(true);
  }
  if (com_jispot_DEBUG >= 3) alert('<<< showSpotMarkers');
}
function hideSpotMarkers() { 
  if (com_jispot_DEBUG >= 3) alert('>>> hideSpotMarkers');
  for(var i=0; i<com_jispot_markers_spot.length; i++){
    if (com_jispot_DEBUG >= 2) alert(i + ': ' + com_jispot_markers_spot[i]);
    com_jispot_markers_spot[i].setVisible(false);
    if (com_jispot_DEBUG >= 2) alert('invisible');
  }
  if (com_jispot_DEBUG >= 3) alert('<<< hideSpotMarkers');
}
function toggleSpotMarkers() { 
  if (com_jispot_DEBUG >= 3) alert('>>> toggleSpotMarkers');
  for(var i=0; i<com_jispot_markers_spot.length; i++){
    com_jispot_markers_spot[i].setVisible(! com_jispot_markers_spot[i].getVisible() );
  }
  if (com_jispot_DEBUG >= 3) alert('<<< toggleSpotMarkers');
}

// ************************************
// SPOT ME !
// We get our last Position (or current if we can and add a draggable
// marker on th position
function on_spotme(json) {
  if (com_jispot_DEBUG >= 3) alert('>>> on_spotme');
  var position = new google.maps.LatLng(json.lat, json.lng);
  com_jispot_map.setCenter(position);
  var marker = new google.maps.Marker( {
    map : com_jispot_map,
    position : position,
    icon: json.icon,
    title : json.description,
    draggable: true
  });
  google.maps.event.addListener(marker, 'dragend', function() {
    // here we have to chage the value of the hidden fields
    // of the form for the lat lng values of the marker
    var lat = marker.getPosition().lat();
    var lng = marker.getPosition().lng();
    if (com_jispot_DEBUG >= 2) alert('Latitude : ' + lat + '\nLongitude: ' + lng);
    $('#fieldLat').val(lat);
    $('#fieldLng').val(lng);
  }); 
  // by default put the current lat/lng to the hidden field
  $('#fieldLat').val(json.lat);
  $('#fieldLng').val(json.lng);
  if (com_jispot_DEBUG >= 3) alert('<<< on_spotme');
}

function on_spotme_success(json) {
  if (com_jispot_DEBUG >= 3) alert('>>> on_spotme_success');
  alert(json.message);
  // Let's show nall markers
  showSpotMarkers();
  if (com_jispot_DEBUG >= 3) alert('<<< on_spotme_success');
}
// ************************************
// SPOT PLAN !
function on_spotplan(json) {
  for (spot in json) {
    var position = new google.maps.LatLng(json[spot].lat, json[spot].lng);
    com_jispot_map.setCenter(position);
    var marker = new google.maps.Marker( {
      position : position,
      map : com_jispot_map,
      title : json[spot].description,
      icon: json[spot].icon
    });
    addSpotMarkers(marker);
  }
}
// ************************************
// SPOTTERS !
function on_spotters(json) {
  for (spot in json) {
    var position = new google.maps.LatLng(json[spot].lat, json[spot].lng);
    com_jispot_map.setCenter(position);
    var marker = new google.maps.Marker( {
      position : position,
      map : com_jispot_map,
      title : json[spot].description,
      icon: json[spot].icon
    });
    addSpotMarkers(marker);
  }
}

// function spotMeAdd() {
// var divContentMap = document.getElementById('map_canvas');
// var divContentForm = document.getElementById('content_form');
//
// // reducing the map
// divContentMap.style.width = "495px";
// // trigger event to resize GoogleMaps content
// google.maps.event.trigger(map, 'resize');
//
// // showing the content
// divContentForm.style.width = "400px";
// divContentForm.style.border = "1px solid #FFF";
// divContentForm.style.marginRight = "3px";
// }
// function spotMeHide() {
// var divContentMap = document.getElementById('map_canvas');
// var divContentForm = document.getElementById('content_form');
//
// // hiding the content
// divContentForm.style.width = "0px";
// divContentForm.style.border = "0px solid #FFF";
// divContentForm.style.marginRight = "0px";
//
// // augmenting the map
// divContentMap.style.width = "900px";
// // trigger event to resize GoogleMaps content
// google.maps.event.trigger(map, 'resize');
//
// }
/* ******************** */
