/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@Beta
public final class Enums {
    private Enums() {
    }

    public static <T extends Enum<T>> Function<String, T> valueOfFunction(Class<T> enumClass) {
        return new ValueOfFunction(enumClass);
    }

    @GoogleInternal
    public static <T extends Enum<T>> Converter<String, T> stringConverter(final Class<T> enumClass) {
        Preconditions.checkNotNull(enumClass);
        return new Converter<String, T>(){

            @Override
            public T convert(String value) {
                return Enum.valueOf(enumClass, value);
            }

            @Override
            public String reverse(T enumValue) {
                return ((Enum)enumValue).name();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueOfFunction<T extends Enum<T>>
    implements Function<String, T> {
        private final Class<T> enumClass;

        private ValueOfFunction(Class<T> enumClass) {
            this.enumClass = Preconditions.checkNotNull(enumClass);
        }

        @Override
        public T apply(String value) {
            try {
                return Enum.valueOf(this.enumClass, value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

