/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;

public class Persistence {
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PeristenceProvider";
    static final String PERSISTENCE_PROVIDER_PROPERTY = "javax.persistence.provider";
    static final String PERSISTENCE_PROVIDER_SERVICE = "META-INF/services/" + PersistenceProvider.class.getName();

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, Collections.EMPTY_MAP);
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        EntityManagerFactory factory;
        Object providerName;
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        if ((providerName = properties.get(PERSISTENCE_PROVIDER_PROPERTY)) instanceof String && (factory = Persistence.createFactory(providerName.toString(), persistenceUnitName, properties)) != null) {
            return factory;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> providers = loader.getResources(PERSISTENCE_PROVIDER_SERVICE);
            while (providers.hasMoreElements()) {
                EntityManagerFactory factory2;
                String name = Persistence.getProviderName(providers.nextElement());
                if (name == null || (factory2 = Persistence.createFactory(name, persistenceUnitName, properties)) == null) continue;
                return factory2;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getProviderName(URL url) throws IOException {
        String providerName;
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
        try {
            providerName = in.readLine();
        }
        finally {
            in.close();
        }
        if (providerName != null) {
            providerName = providerName.trim();
        }
        return providerName;
    }

    static EntityManagerFactory createFactory(String providerName, String persistenceUnitName, Map properties) throws PersistenceException {
        Class<?> providerClass;
        try {
            providerClass = Class.forName(providerName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new PersistenceException("Invalid or inaccessible provider class: " + providerName, e);
        }
        try {
            PersistenceProvider provider = (PersistenceProvider)providerClass.newInstance();
            return provider.createEntityManagerFactory(persistenceUnitName, properties);
        }
        catch (Exception e) {
            throw new PersistenceException("Provider error. Provider: " + providerName, e);
        }
    }
}

