/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class BooleanLiteral
extends BooleanExpression
implements Literal {
    private final boolean value;
    Object rawValue;

    public BooleanLiteral(QueryExpression qs, JavaTypeMapping mapping, boolean value) {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        this.st.append(value ? this.getBooleanTrueValue() : this.getBooleanFalseValue());
    }

    public Object getValue() {
        return new Boolean(this.value);
    }

    protected String getBooleanTrueValue() {
        return "TRUE";
    }

    protected String getBooleanFalseValue() {
        return "(1=0)";
    }

    public BooleanExpression and(ScalarExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? (BooleanExpression)expr : this;
        }
        return super.and(expr);
    }

    public BooleanExpression eor(ScalarExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? expr.not() : (BooleanExpression)expr;
        }
        return super.eor(expr);
    }

    public BooleanExpression ior(ScalarExpression expr) {
        if (expr instanceof BooleanExpression) {
            return this.value ? this : (BooleanExpression)expr;
        }
        return super.ior(expr);
    }

    public BooleanExpression not() {
        return new BooleanLiteral(this.qs, this.mapping, !this.value);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, BooleanExpression.class);
        if (expr instanceof BooleanExpression) {
            return this.value ? (BooleanExpression)expr : expr.not();
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, BooleanExpression.class);
        if (expr instanceof BooleanExpression) {
            return this.value ? expr.not() : (BooleanExpression)expr;
        }
        return super.noteq(expr);
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }
}

