/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import org.springmodules.validation.util.condition.collection.AbstractCollectionCondition;

public class SizeRangeCollectionCondition
extends AbstractCollectionCondition {
    private int minSize;
    private int maxSize;

    public SizeRangeCollectionCondition(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    protected boolean checkArray(Object array) {
        int length = Array.getLength(array);
        return length >= this.minSize && length <= this.maxSize;
    }

    protected boolean checkCollection(Collection collection) {
        int size = collection.size();
        return size >= this.minSize && size <= this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

