/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyDescriptor
implements Serializable {
    private transient MethodParameter methodParameter;
    private transient Field field;
    private Class declaringClass;
    private String methodName;
    private Class[] parameterTypes;
    private int parameterIndex;
    private String fieldName;
    private final boolean required;
    private final boolean eager;
    private transient Annotation[] fieldAnnotations;

    public DependencyDescriptor(MethodParameter methodParameter, boolean required) {
        this(methodParameter, required, true);
    }

    public DependencyDescriptor(MethodParameter methodParameter, boolean required, boolean eager) {
        Assert.notNull((Object)methodParameter, (String)"MethodParameter must not be null");
        this.methodParameter = methodParameter;
        this.declaringClass = methodParameter.getDeclaringClass();
        if (this.methodParameter.getMethod() != null) {
            this.methodName = methodParameter.getMethod().getName();
            this.parameterTypes = methodParameter.getMethod().getParameterTypes();
        } else {
            this.parameterTypes = methodParameter.getConstructor().getParameterTypes();
        }
        this.parameterIndex = methodParameter.getParameterIndex();
        this.required = required;
        this.eager = eager;
    }

    public DependencyDescriptor(Field field, boolean required) {
        this(field, required, true);
    }

    public DependencyDescriptor(Field field, boolean required, boolean eager) {
        Assert.notNull((Object)field, (String)"Field must not be null");
        this.field = field;
        this.declaringClass = field.getDeclaringClass();
        this.fieldName = field.getName();
        this.required = required;
        this.eager = eager;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isEager() {
        return this.eager;
    }

    public void initParameterNameDiscovery(ParameterNameDiscoverer parameterNameDiscoverer) {
        if (this.methodParameter != null) {
            this.methodParameter.initParameterNameDiscovery(parameterNameDiscoverer);
        }
    }

    public String getDependencyName() {
        return this.field != null ? this.field.getName() : this.methodParameter.getParameterName();
    }

    public Class<?> getDependencyType() {
        return this.field != null ? this.field.getType() : this.methodParameter.getParameterType();
    }

    public Type getGenericDependencyType() {
        return this.field != null ? this.field.getGenericType() : this.methodParameter.getGenericParameterType();
    }

    public Class<?> getCollectionType() {
        return this.field != null ? GenericCollectionTypeResolver.getCollectionFieldType((Field)this.field) : GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)this.methodParameter);
    }

    public Class<?> getMapKeyType() {
        return this.field != null ? GenericCollectionTypeResolver.getMapKeyFieldType((Field)this.field) : GenericCollectionTypeResolver.getMapKeyParameterType((MethodParameter)this.methodParameter);
    }

    public Class<?> getMapValueType() {
        return this.field != null ? GenericCollectionTypeResolver.getMapValueFieldType((Field)this.field) : GenericCollectionTypeResolver.getMapValueParameterType((MethodParameter)this.methodParameter);
    }

    public Annotation[] getAnnotations() {
        if (this.field != null) {
            if (this.fieldAnnotations == null) {
                this.fieldAnnotations = this.field.getAnnotations();
            }
            return this.fieldAnnotations;
        }
        return this.methodParameter.getParameterAnnotations();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            if (this.fieldName != null) {
                this.field = this.declaringClass.getDeclaredField(this.fieldName);
            } else {
                this.methodParameter = this.methodName != null ? new MethodParameter(this.declaringClass.getDeclaredMethod(this.methodName, this.parameterTypes), this.parameterIndex) : new MethodParameter(this.declaringClass.getDeclaredConstructor(this.parameterTypes), this.parameterIndex);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not find original class structure", ex);
        }
    }
}

