package com.jispot.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONSerializer;

import org.apache.commons.httpclient.HttpStatus;


/**
 * This class is a Helper.<br>
 * JSON and XML parsing
 */
public class SXManager {

	protected final Logger log = Logger.getLogger(this.getClass().getName());

    /**
     * SSX SECURITY is just a parameter always true (at <br>
     * the moment) that could be usefull if a full BFly <br>
     * installation requires no api_signature like an <br>
     * intranet or a trustful environement, <br>
     * for integration ease. <br>
     * <br>
     * Can easily be externalized in a property file when we will need it...
     */
    public static final boolean SX_SECURITY_ACTIV     = true;

    public static final String  REQUEST_API_KEY        = "api_key";
    public static final String  REQUEST_API_SIG        = "api_sig";

    public static final String  RESPONSE_RESULT        = "result";

    public static final String  RESPONSE_ERROR_CODE    = "error_code";
    public static final String  RESPONSE_ERROR_MESSAGE = "error_message";
    public static final String  RESPONSE_ERROR_DETAIL  = "error_detail";

    /**
     * MD5 checksum upon request parameters or attributes except api_sig and api_key if found
     * 
     * @param request the HttpRequest to parse
     * @return the calculated checksum
     * @throws Exception if an error occurs
     */
    @SuppressWarnings( "unchecked" )
    public static String calculateChecksum( HttpServletRequest request , String salt ) throws Throwable {
        // here we must check the api_key, the parameters and do the api_sig verification
        // We get the request parameters
        List<Param> params = RequestUtils.getAttributesOrParameters( request );

        // except api_key and api_sig
        Iterator<Param> ite = params.iterator();
        while ( ite.hasNext() ) {
            Param param = ite.next();
            if ( SXManager.REQUEST_API_KEY.equalsIgnoreCase( param.getName() )
                    || SXManager.REQUEST_API_SIG.equalsIgnoreCase( param.getName() ) ) {
                ite.remove();
            }
        }

        // We order them by parameter's alphabetic order
        Collections.sort( params );
        // We prefix the ordered params with the tenant application's salt found with the api_key
        String orderedParams = salt;
        for ( Iterator<Param> iterator = params.iterator() ; iterator.hasNext() ; ) {
            Param param = iterator.next();
            if ( param != null && StringUtils.isNotNullOrEmpty( param.toString() ) ) {
                orderedParams += param.toString();
            }
        }

        // we calculate the MD5 checksum of the salted ordered params
        return Hash.hacher( orderedParams , Hash.HASH_MD5 );
    }

    /**
     * @param request
     * @param result
     */
    public static void registerResult( HttpServletRequest request , Object result ) throws Throwable {
        request.setAttribute( SXManager.RESPONSE_RESULT , new Result( HttpStatus.SC_OK , result ) );
    }

    /**
     * @param request
     * @param response
     */
    public static void sendResult( HttpServletRequest request , HttpServletResponse response ) {
        
        Object result = request.getAttribute( RESPONSE_RESULT );
    	SXManager.sendJSONResult( response , result );

    	// *****************************
    	//CE BOUT DE CODE EST DESACTIVE ET SERA A NOUVEAU UTILE 
    	// EN CAS D'ANALYSE DU SUFFIXE DE L'URL APPELEE
//        // Lets get the end of the request URI in order to dispatch correctly
//        String suffix = "json";
//        int index = request.getRequestURI().lastIndexOf( "." );
//        if ( index != -1 ) {
//            suffix = request.getRequestURI().substring( index + 1 );
//        }
//        if ( suffix.equalsIgnoreCase( "json" ) ) {
//            SSXManager.sendJSONResult( response , result );
//        }
//        else if ( suffix.equalsIgnoreCase( "xml" ) ) {
//            SSXManager.sendXMLResult( response , result );
//        }
//        else {
//            SSXManager.sendJSONResult( response , result );
//        }
    }

    /**
     * Sends the json Result to the front
     * @throws JISpotEx 
     */
    public static void sendJSONResult( HttpServletResponse response , Object result ) {
        try {
			PrintWriter out = response.getWriter();
			response.setContentType( "application/json" );
			response.setHeader( "Cache-Control" , "no-cache" );

			String jsonOut = JSONSerializer.toJSON( result ).toString();

			out.write( jsonOut );
			out.flush();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }

//    /**
//     * Sends the xml Result to the front
//     */
//    public static void sendXMLResult( HttpServletResponse response , Object result ) throws Throwable {
//        PrintWriter out = response.getWriter();
//        response.setContentType( "application/xml" );
//        response.setHeader( "Cache-Control" , "no-cache" );
//
//        StringWriter content = new StringWriter();
//        final Marshaller marshaller = new Marshaller( content );
//        marshaller.setValidation( false );
//        marshaller.setEncoding( "UTF-8" );
//        marshaller.setSuppressXSIType( true );
//        marshaller.marshal( result );
//
//        String xmlOut = content.toString();
//        if ( log.isTraceEnabled() ) log.trace( "\n-------------------------------\nXML output :\n" + xmlOut );
//
//        out.write( xmlOut );
//        out.flush();
//    }

}
