/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.Entity;
import java.util.Iterator;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.QueryExceptionWrappers;
import org.datanucleus.store.appengine.query.RuntimeExceptionObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuntimeExceptionWrappingIterator
implements Iterator<Entity> {
    final Iterator<Entity> inner;
    final Utils.Supplier<Boolean> hasNextSupplier;
    final Utils.Supplier<Entity> nextSupplier;
    final Utils.Supplier<Void> removeSupplier;

    RuntimeExceptionWrappingIterator(final Iterator<Entity> inner, boolean isJPA, final RuntimeExceptionObserver exceptionObserver) {
        if (inner == null) {
            throw new NullPointerException("inner cannot be null");
        }
        this.inner = inner;
        Utils.Supplier<Boolean> datastoreHasNextSupplier = QueryExceptionWrappers.datastoreToDataNucleus(new Utils.Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                boolean success = false;
                try {
                    boolean result = inner.hasNext();
                    success = true;
                    Boolean bl = result;
                    return bl;
                }
                finally {
                    if (!success) {
                        exceptionObserver.onException();
                    }
                }
            }
        });
        Utils.Supplier<Entity> datastoreNextSupplier = QueryExceptionWrappers.datastoreToDataNucleus(new Utils.Supplier<Entity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Entity get() {
                boolean success = false;
                try {
                    Entity result = (Entity)inner.next();
                    success = true;
                    Entity entity = result;
                    return entity;
                }
                finally {
                    if (!success) {
                        exceptionObserver.onException();
                    }
                }
            }
        });
        Utils.Supplier<Void> datastoreRemoveSupplier = QueryExceptionWrappers.datastoreToDataNucleus(new Utils.Supplier<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void get() {
                boolean success = false;
                try {
                    inner.remove();
                    success = true;
                    Void void_ = null;
                    return void_;
                }
                finally {
                    if (!success) {
                        exceptionObserver.onException();
                    }
                }
            }
        });
        if (isJPA) {
            this.hasNextSupplier = QueryExceptionWrappers.dataNucleusToJPA(datastoreHasNextSupplier);
            this.nextSupplier = QueryExceptionWrappers.dataNucleusToJPA(datastoreNextSupplier);
            this.removeSupplier = QueryExceptionWrappers.dataNucleusToJPA(datastoreRemoveSupplier);
        } else {
            this.hasNextSupplier = QueryExceptionWrappers.dataNucleusToJDO(datastoreHasNextSupplier);
            this.nextSupplier = QueryExceptionWrappers.dataNucleusToJDO(datastoreNextSupplier);
            this.removeSupplier = QueryExceptionWrappers.dataNucleusToJDO(datastoreRemoveSupplier);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNextSupplier.get();
    }

    @Override
    public Entity next() {
        return this.nextSupplier.get();
    }

    @Override
    public void remove() {
        this.removeSupplier.get();
    }
}

