/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import java.util.Map;
import javax.jdo.JDOQueryTimeoutException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.FatalNucleusUserException;
import org.datanucleus.store.appengine.query.DatastoreQuery;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.QueryTimeoutException;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    private final DatastoreQuery datastoreQuery = new DatastoreQuery((AbstractJavaQuery)this);

    public JDOQLQuery(ObjectManager om) {
        this(om, (JDOQLQuery)null);
    }

    public JDOQLQuery(ObjectManager om, JDOQLQuery q) {
        super(om, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(ObjectManager om, String query) {
        super(om, query);
    }

    protected Object performExecute(Map parameters) {
        Map params = parameters;
        if (this.range != null && !this.range.equals("")) {
            String[] fromTo = this.range.split(",");
            if (fromTo.length != 2) {
                throw new NucleusUserException("Malformed RANGE clause: " + this.range);
            }
            this.fromInclNo = Long.parseLong(fromTo[0].trim());
            this.toExclNo = Long.parseLong(fromTo[1].trim());
        }
        try {
            return this.datastoreQuery.performExecute(LOCALISER, this.compilation, this.fromInclNo, this.toExclNo, params, true);
        }
        catch (QueryTimeoutException e) {
            throw new JDOQueryTimeoutException(e.getMessage());
        }
    }

    DatastoreQuery getDatastoreQuery() {
        return this.datastoreQuery;
    }

    protected void checkParameterTypesAgainstCompilation(Map parameterValues) {
    }

    public void setSubclasses(boolean subclasses) {
        if (subclasses && !this.allowSubClasses()) {
            throw new FatalNucleusUserException("The App Engine datastore only supports queries that return subclass entities with the superclass-table interitance mapping strategy.");
        }
        super.setSubclasses(subclasses);
    }

    private boolean allowSubClasses() {
        DatastoreManager storeMgr = (DatastoreManager)this.om.getStoreManager();
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        AbstractClassMetaData acmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), clr);
        return DatastoreManager.isNewOrSuperclassTableInheritanceStrategy(acmd);
    }
}

