/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.rule;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springmodules.validation.bean.rule.AbstractValidationRule;
import org.springmodules.validation.util.condition.AbstractCondition;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.condition.ConditionException;

public class ValidationMethodValidationRule
extends AbstractValidationRule {
    private MethodCondition condition;

    public ValidationMethodValidationRule(Method method) {
        super(method.getName() + "()");
        this.condition = new MethodCondition(method);
    }

    public Condition getCondition() {
        return this.condition;
    }

    private class MethodCondition
    extends AbstractCondition {
        private Method method;

        public MethodCondition(Method method) {
            this.method = method;
        }

        public boolean doCheck(Object object) {
            try {
                boolean originalAccessiblity = this.method.isAccessible();
                this.method.setAccessible(true);
                Boolean valid = (Boolean)this.method.invoke(object, new Object[0]);
                this.method.setAccessible(originalAccessiblity);
                return valid;
            }
            catch (IllegalAccessException iae) {
                throw new ConditionException("Could not validate object using validation method '" + this.method.getName() + "'", iae);
            }
            catch (InvocationTargetException ite) {
                throw new ConditionException("Could not validate object using validation method '" + this.method.getName() + "'", ite);
            }
        }
    }
}

