/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class Buffers {
    public static InputStream asInputStream(ByteBuffer buf, int len) {
        int numExcessBytes = buf.remaining() - len;
        if (numExcessBytes < 0) {
            throw new IllegalArgumentException("Length is excessive " + len);
        }
        return Buffers.asInputStreamInternal(buf, numExcessBytes);
    }

    public static InputStream asInputStream(ByteBuffer buf) {
        return Buffers.asInputStreamInternal(buf, 0);
    }

    private static InputStream asInputStreamInternal(final ByteBuffer buf, final int numExcessBytes) {
        return new InputStream(){

            public int read() {
                return buf.remaining() == numExcessBytes ? -1 : buf.get() & 0xFF;
            }

            public int read(byte[] dest) {
                return this.readInternal(dest, 0, dest.length);
            }

            public int read(byte[] dest, int offset, int len) {
                if (offset < 0 || len < 0 || offset + len > dest.length) {
                    throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + len);
                }
                return this.readInternal(dest, offset, len);
            }

            private int readInternal(byte[] dest, int offset, int len) {
                if (len == 0) {
                    return 0;
                }
                int numBytesToReturn = Math.min(len, this.available());
                if (numBytesToReturn == 0) {
                    return -1;
                }
                buf.get(dest, offset, numBytesToReturn);
                return numBytesToReturn;
            }

            public long skip(long n) {
                int result = n < 0L ? 0 : (int)Math.min(n, (long)this.available());
                buf.position(buf.position() + result);
                return result;
            }

            public int available() {
                return buf.remaining() - numExcessBytes;
            }
        };
    }

    public static OutputStream asOutputStream(final ByteBuffer buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        return new OutputStream(){

            public void write(int b) {
                buf.put((byte)b);
            }

            public void write(byte[] src) throws IOException {
                try {
                    buf.put(src);
                }
                catch (RuntimeException e) {
                    throw new IOException(e.toString());
                }
            }

            public void write(byte[] src, int offset, int len) throws IOException {
                try {
                    buf.put(src, offset, len);
                }
                catch (IndexOutOfBoundsException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new IOException(e.toString());
                }
            }
        };
    }

    public static class ByteArrayAdapter {
        private final ByteBuffer buf;
        public final byte[] arr;
        public final int offset;
        public final int length;

        public ByteArrayAdapter(ByteBuffer buf) {
            if (buf == null) {
                throw new NullPointerException();
            }
            this.buf = buf;
            this.length = buf.remaining();
            if (buf.hasArray()) {
                this.arr = buf.array();
                this.offset = buf.arrayOffset() + buf.position();
            } else {
                this.arr = new byte[this.length];
                buf.get(this.arr, 0, this.length);
                this.offset = 0;
            }
        }

        public void merge(int numBytes) {
            if (this.buf.hasArray()) {
                this.buf.position(this.buf.position() + numBytes);
            } else {
                this.buf.put(this.arr, this.offset, numBytes);
            }
        }
    }
}

