/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.context.web;

import java.beans.PropertyEditorManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springmodules.validation.bean.context.ValidationContextUtils;
import org.springmodules.validation.bean.context.web.ValidationContextUrlMapping;

public class ValidationContextHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springmodules$validation$bean$context$web$ValidationContextHandlerInterceptor == null ? (class$org$springmodules$validation$bean$context$web$ValidationContextHandlerInterceptor = ValidationContextHandlerInterceptor.class$("org.springmodules.validation.bean.context.web.ValidationContextHandlerInterceptor")) : class$org$springmodules$validation$bean$context$web$ValidationContextHandlerInterceptor));
    private ValidationContextUrlMapping[] validationContextUrlMappings = new ValidationContextUrlMapping[0];
    private PathMatcher pathMatcher = new AntPathMatcher();
    static /* synthetic */ Class class$org$springmodules$validation$bean$context$web$ValidationContextHandlerInterceptor;
    static /* synthetic */ Class array$Lorg$springmodules$validation$bean$context$web$ValidationContextUrlMapping;
    static /* synthetic */ Class class$org$springmodules$validation$bean$context$web$ValidationContextUrlMappingArrayPropertyEditor;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String[] contextTokens = new String[]{};
        for (int i = 0; i < this.validationContextUrlMappings.length; ++i) {
            String pattern = this.validationContextUrlMappings[i].getUrlPattern();
            if (!this.pathMatcher.match(pattern, request.getRequestURI())) continue;
            contextTokens = this.validationContextUrlMappings[i].getContextTokens();
            break;
        }
        if (logger.isInfoEnabled() && contextTokens.length == 0) {
            logger.info((Object)("No validation context url mapping matches url '" + request.getRequestURI() + "'. Setting validation context without supported tokens..."));
        }
        ValidationContextUtils.setContext(contextTokens);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        ValidationContextUtils.clearContext();
    }

    public ValidationContextUrlMapping[] getValidationContextUrlMappings() {
        return this.validationContextUrlMappings;
    }

    public void setValidationContextUrlMappings(ValidationContextUrlMapping[] validationContextUrlMappings) {
        this.validationContextUrlMappings = validationContextUrlMappings;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertyEditorManager.registerEditor(array$Lorg$springmodules$validation$bean$context$web$ValidationContextUrlMapping == null ? (array$Lorg$springmodules$validation$bean$context$web$ValidationContextUrlMapping = ValidationContextHandlerInterceptor.class$("[Lorg.springmodules.validation.bean.context.web.ValidationContextUrlMapping;")) : array$Lorg$springmodules$validation$bean$context$web$ValidationContextUrlMapping, class$org$springmodules$validation$bean$context$web$ValidationContextUrlMappingArrayPropertyEditor == null ? (class$org$springmodules$validation$bean$context$web$ValidationContextUrlMappingArrayPropertyEditor = ValidationContextHandlerInterceptor.class$("org.springmodules.validation.bean.context.web.ValidationContextUrlMappingArrayPropertyEditor")) : class$org$springmodules$validation$bean$context$web$ValidationContextUrlMappingArrayPropertyEditor);
    }
}

