/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class CompoundExpression
extends SpelNodeImpl {
    public CompoundExpression(int pos, SpelNodeImpl ... expressionComponents) {
        super(pos, expressionComponents);
        if (expressionComponents.length < 2) {
            throw new IllegalStateException("Dont build compound expression less than one entry: " + expressionComponents.length);
        }
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue result = null;
        SpelNodeImpl nextNode = null;
        try {
            nextNode = this.children[0];
            result = nextNode.getValueInternal(state);
            int i = 1;
            while (i < this.getChildCount()) {
                try {
                    state.pushActiveContextObject(result);
                    nextNode = this.children[i];
                    result = nextNode.getValueInternal(state);
                }
                finally {
                    state.popActiveContextObject();
                }
                ++i;
            }
        }
        catch (SpelEvaluationException ee) {
            ee.setPosition(nextNode.getStartPosition());
            throw ee;
        }
        return result;
    }

    public void setValue(ExpressionState state, Object value) throws EvaluationException {
        if (this.getChildCount() == 1) {
            this.getChild(0).setValue(state, value);
            return;
        }
        TypedValue ctx = this.children[0].getValueInternal(state);
        int i = 1;
        while (i < this.getChildCount() - 1) {
            try {
                state.pushActiveContextObject(ctx);
                ctx = this.children[i].getValueInternal(state);
            }
            finally {
                state.popActiveContextObject();
            }
            ++i;
        }
        try {
            state.pushActiveContextObject(ctx);
            this.getChild(this.getChildCount() - 1).setValue(state, value);
        }
        finally {
            state.popActiveContextObject();
        }
    }

    public boolean isWritable(ExpressionState state) throws EvaluationException {
        if (this.getChildCount() == 1) {
            return this.getChild(0).isWritable(state);
        }
        TypedValue ctx = this.children[0].getValueInternal(state);
        int i = 1;
        while (i < this.getChildCount() - 1) {
            try {
                state.pushActiveContextObject(ctx);
                ctx = this.children[i].getValueInternal(state);
            }
            finally {
                state.popActiveContextObject();
            }
            ++i;
        }
        try {
            state.pushActiveContextObject(ctx);
            boolean bl = this.getChild(this.getChildCount() - 1).isWritable(state);
            return bl;
        }
        finally {
            state.popActiveContextObject();
        }
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.getChildCount()) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        return sb.toString();
    }
}

