package com.jispot.domain.model;

import siena.*;

@Table("api_key")
public class Apikey extends Model {

	@Id(Generator.AUTO_INCREMENT)
	public Long id;

    @Column("key")
    @Max(512)
    @NotNull
    @Unique("name_index")
    public String key;
    
    @Column("valid")
    public boolean valid = false;
    
    @Column("application")
    public Application application;

    public static Query<Apikey> all() {
		return Model.all(Apikey.class);
	}

}
