/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.bean;

import org.springframework.beans.BeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springmodules.validation.util.condition.bean.AbstractBeanCondition;

public class EqualPropertiesBeanCondition
extends AbstractBeanCondition {
    private String[] propertyNames;

    public EqualPropertiesBeanCondition(String[] propertyNames) {
        Assert.notNull((Object)propertyNames, (String)(this.getClass().getName() + " cannot be initialized with null array of property names"));
        Assert.notEmpty((Object[])propertyNames, (String)(this.getClass().getName() + " cannot be initialized with less then 2 property names"));
        for (int i = 0; i < propertyNames.length; ++i) {
            Assert.notNull((Object)propertyNames[i], (String)(this.getClass().getName() + " cannot be initialized with null property name"));
        }
        this.propertyNames = propertyNames;
    }

    public EqualPropertiesBeanCondition(String property1, String property2) {
        this(new String[]{property1, property2});
    }

    protected boolean checkBean(BeanWrapper bean) {
        Object value = bean.getPropertyValue(this.propertyNames[0]);
        for (int i = 1; i < this.propertyNames.length; ++i) {
            Object currentValue = bean.getPropertyValue(this.propertyNames[i]);
            if (ObjectUtils.nullSafeEquals((Object)value, (Object)currentValue)) continue;
            return false;
        }
        return true;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }
}

