/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.ObjectLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MultiMapping;
import org.datanucleus.util.NucleusLogger;

public class SubclassPCMapping
extends MultiMapping {
    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.prepareDatastoreMapping(clr);
    }

    protected void prepareDatastoreMapping(ClassLoaderResolver clr) {
        if (this.roleForMember != 4 && this.roleForMember != 3 && this.roleForMember != 5 && this.roleForMember != 6) {
            MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
            AbstractClassMetaData refCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.mmd.getType(), clr);
            if (refCmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.SUBCLASS_TABLE) {
                throw new NucleusUserException(LOCALISER.msg("020185", (Object)this.mmd.getFullFieldName()));
            }
            AbstractClassMetaData[] subclassCmds = storeMgr.getClassesManagingTableForClass(refCmd, clr);
            boolean pk = false;
            if (subclassCmds.length > 1) {
                pk = false;
            }
            boolean nullable = true;
            if (subclassCmds.length > 1) {
                nullable = true;
            }
            int colPos = 0;
            for (int i = 0; i < subclassCmds.length; ++i) {
                Class type = clr.classForName(subclassCmds[i].getFullClassName());
                DatastoreClass dc = storeMgr.getDatastoreClass(subclassCmds[i].getFullClassName(), clr);
                JavaTypeMapping m = dc.getIDMapping();
                ColumnMetaData[] columnMetaDataForType = null;
                if (this.mmd.getColumnMetaData() != null && this.mmd.getColumnMetaData().length > 0) {
                    if (this.mmd.getColumnMetaData().length < colPos + m.getNumberOfDatastoreFields()) {
                        throw new NucleusUserException(LOCALISER.msg("020186", (Object)this.mmd.getFullFieldName(), (Object)("" + this.mmd.getColumnMetaData().length), (Object)("" + (colPos + m.getNumberOfDatastoreFields()))));
                    }
                    columnMetaDataForType = new ColumnMetaData[m.getNumberOfDatastoreFields()];
                    System.arraycopy(this.mmd.getColumnMetaData(), colPos, columnMetaDataForType, 0, columnMetaDataForType.length);
                    colPos += columnMetaDataForType.length;
                }
                ColumnCreator.createColumnsForField(type, this, this.datastoreContainer, storeMgr, this.mmd, pk, nullable, false, false, 2, columnMetaDataForType, clr, true);
                if (!NucleusLogger.DATASTORE.isInfoEnabled()) continue;
                NucleusLogger.DATASTORE.info(LOCALISER.msg("020187", type, (Object)this.mmd.getName()));
            }
        }
    }

    public Class getJavaType() {
        return null;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return new ObjectLiteral(qs, this, value, value.getClass().getName());
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return new ObjectExpression(qs, this, te);
    }
}

