/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.management.runtime;

import org.datanucleus.management.runtime.QueryRuntimeMBean;
import org.datanucleus.util.MathUtils;

public class QueryRuntime
implements QueryRuntimeMBean {
    long activeTotalCount;
    long errorTotalCount;
    long executionTotalCount;
    long executionTotalTime = 0L;
    long executionTimeHigh = -1L;
    long executionTimeLow = -1L;
    MathUtils.SMA executionTimeAverage = new MathUtils.SMA(50);

    public long getQueryActiveTotalCount() {
        return this.activeTotalCount;
    }

    public long getQueryErrorTotalCount() {
        return this.errorTotalCount;
    }

    public long getQueryExecutionTotalCount() {
        return this.executionTotalCount;
    }

    public long getQueryExecutionTimeLow() {
        return this.executionTimeLow;
    }

    public long getQueryExecutionTimeHigh() {
        return this.executionTimeHigh;
    }

    public long getQueryExecutionTotalTime() {
        return this.executionTotalTime;
    }

    public long getQueryExecutionTimeAverage() {
        return (long)this.executionTimeAverage.currentAverage();
    }

    public void queryBegin() {
        ++this.activeTotalCount;
    }

    public void queryExecutedWithError() {
        ++this.errorTotalCount;
        --this.activeTotalCount;
    }

    public void queryExecuted(long executionTime) {
        ++this.executionTotalCount;
        --this.activeTotalCount;
        this.executionTimeAverage.compute(executionTime);
        this.executionTimeLow = Math.min(this.executionTimeLow == -1L ? executionTime : this.executionTimeLow, executionTime);
        this.executionTimeHigh = Math.max(this.executionTimeHigh, executionTime);
        this.executionTotalTime += executionTime;
    }
}

