/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.io.protocol.ExtensionTags;
import com.google.appengine.repackaged.com.google.io.protocol.Extensions;
import com.google.appengine.repackaged.com.google.io.protocol.LazyParsingExtension;
import com.google.appengine.repackaged.com.google.io.protocol.ProtoString;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtendableProtocolMessage<T extends ExtendableProtocolMessage<T>>
extends ProtocolMessage<T> {
    protected ExtensionTags uninterpreted;

    public final boolean hasExtension(Extensions.Extension<T, ?> extension) {
        if (this.uninterpreted == null) {
            return false;
        }
        return this.uninterpreted.containsKey(extension.getWireTag());
    }

    public final boolean hasExtension(Extensions.RepeatedExtension<T, ?> extension) {
        if (this.uninterpreted == null) {
            return false;
        }
        return this.uninterpreted.containsKey(extension.getWireTag()) && !((List)this.uninterpreted.get(extension.getWireTag()).read(extension)).isEmpty();
    }

    public final <Ex> Ex getExtension(Extensions.Extension<T, Ex> extension) {
        if (this.uninterpreted == null) {
            return extension.defaultValue();
        }
        LazyParsingExtension ext = this.uninterpreted.get(extension.getWireTag());
        return ext == null ? extension.defaultValue() : extension.unmodifiable(ext.read(extension));
    }

    public final <Ex extends ProtocolMessage<Ex>> Ex getMutableExtension(Extensions.Extension<T, Ex> extension) {
        return (Ex)((ProtocolMessage)this.internalGetMutableExtension(extension));
    }

    public final <Ex> List<Ex> getMutableExtension(Extensions.RepeatedExtension<T, Ex> extension) {
        return (List)this.internalGetMutableExtension(extension);
    }

    private final <Ex> Ex internalGetMutableExtension(Extensions.Extension<T, Ex> extension) {
        this.getUninterpretedForWrite();
        LazyParsingExtension ext = this.uninterpreted.get(extension.getWireTag());
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(extension.getWireTag(), ext);
        }
        return ext.read(extension);
    }

    public final <Ex> Ex getExtension(Extensions.RepeatedExtension<T, Ex> extension, int index) {
        return (Ex)((List)this.getExtension(extension)).get(index);
    }

    public final int extensionSize(Extensions.RepeatedExtension<T, ?> extension) {
        return ((List)this.getExtension(extension)).size();
    }

    public final <Ex> T setExtension(Extensions.Extension<T, Ex> extension, Ex value) {
        this.getUninterpretedForWrite().putExtension(extension.getWireTag(), LazyParsingExtension.parsed(extension, value));
        return (T)this;
    }

    public final T setExtension(Extensions.Extension<T, Integer> extension, ProtocolMessageEnum enumValue) {
        return this.setExtension(extension, enumValue.getValue());
    }

    public final T setExtension(Extensions.Extension<T, ProtoString> extension, String value) {
        return this.setExtension(extension, new ProtoString(value));
    }

    public final T setExtension(Extensions.Extension<T, ProtoString> extension, byte[] value) {
        return this.setExtension(extension, new ProtoString(value));
    }

    public final <Ex> T setExtension(Extensions.RepeatedExtension<T, Ex> extension, int index, Ex value) {
        this.getUninterpretedForWrite();
        LazyParsingExtension ext = this.uninterpreted.get(extension.getWireTag());
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(extension.getWireTag(), ext);
        }
        ((List)ext.read(extension)).set(index, value);
        return (T)this;
    }

    public final T setExtension(Extensions.RepeatedExtension<T, Integer> extension, int index, ProtocolMessageEnum enumValue) {
        return this.setExtension(extension, index, enumValue.getValue());
    }

    public final T setExtension(Extensions.RepeatedExtension<T, ProtoString> extension, int index, String value) {
        return this.setExtension(extension, index, new ProtoString(value));
    }

    public final T setExtension(Extensions.RepeatedExtension<T, ProtoString> extension, int index, byte[] value) {
        return this.setExtension(extension, index, new ProtoString(value));
    }

    public final <Ex> T addExtension(Extensions.RepeatedExtension<T, Ex> extension, Ex value) {
        this.getUninterpretedForWrite();
        LazyParsingExtension ext = this.uninterpreted.get(extension.getWireTag());
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(extension.getWireTag(), ext);
        }
        ((List)ext.read(extension)).add(value);
        return (T)this;
    }

    public final T addExtension(Extensions.RepeatedExtension<T, Integer> extension, ProtocolMessageEnum enumValue) {
        return this.addExtension(extension, enumValue.getValue());
    }

    public final T addExtension(Extensions.RepeatedExtension<T, ProtoString> extension, String value) {
        return this.addExtension(extension, new ProtoString(value));
    }

    public final T addExtension(Extensions.RepeatedExtension<T, ProtoString> extension, byte[] value) {
        return this.addExtension(extension, new ProtoString(value));
    }

    public final <Ex extends ProtocolMessage<Ex>> Ex addExtension(Extensions.RepeatedExtension<T, Ex> extension) {
        Object result = ((ProtocolMessage)extension.unitDefaultValue()).newInstance();
        this.getUninterpretedForWrite();
        LazyParsingExtension ext = this.uninterpreted.get(extension.getWireTag());
        if (ext == null) {
            ext = LazyParsingExtension.empty(extension);
            this.uninterpreted.putExtension(extension.getWireTag(), ext);
        }
        ((List)ext.read(extension)).add(result);
        return (Ex)result;
    }

    public final <Ex> T clearExtension(Extensions.Extension<T, Ex> extension) {
        if (this.uninterpreted != null) {
            this.getUninterpretedForWrite().remove(extension.getWireTag());
        }
        return (T)this;
    }

    public final void makeReadAccessThreadSafe(Extensions.Extension<T, ?> ... extensions) {
        ExtensionTags tags = this.getUninterpretedForWrite();
        for (Extensions.Extension<?, ?> extension : extensions) {
            LazyParsingExtension lpe = tags.get(extension.getWireTag());
            if (lpe == null) continue;
            lpe.read(extension);
        }
    }

    @Override
    public final int hashCode() {
        throw new UnsupportedOperationException("hashCode unsupported for messages with extensions");
    }

    protected abstract ExtensionTags getUninterpretedForWrite();
}

