/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.context.aop;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springmodules.validation.bean.context.ValidationContext;
import org.springmodules.validation.bean.context.ValidationContextHolder;
import org.springmodules.validation.bean.context.ValidationContextUtils;

public abstract class AbstractValidationContextInterceptor
implements MethodInterceptor {
    private boolean extendExistingContext = false;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String[] contextTokens = this.getValidationContextTokens(methodInvocation);
        ValidationContext originalContext = ValidationContextHolder.getValidationContext();
        if (originalContext != null && this.extendExistingContext) {
            ValidationContextUtils.extendContext(contextTokens);
        } else {
            ValidationContextUtils.setContext(contextTokens);
        }
        Object result = methodInvocation.proceed();
        if (originalContext != null) {
            ValidationContextHolder.setValidationContext(originalContext);
        } else {
            ValidationContextUtils.clearContext();
        }
        return result;
    }

    protected abstract String[] getValidationContextTokens(MethodInvocation var1);

    public void setExtendExistingContext(boolean extendExistingContext) {
        this.extendExistingContext = extendExistingContext;
    }
}

