/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.ShortBlob;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.appengine.PrimitiveArrays;
import org.datanucleus.store.appengine.PrimitiveUtils;
import org.datanucleus.store.appengine.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeConversionUtils {
    private static final Utils.Function<Object, Object> LONG_TO_INTEGER = new Utils.Function<Object, Object>(){

        @Override
        public Integer apply(Object in) {
            return ((Long)in).intValue();
        }
    };
    private static final Utils.Function<Object, Object> LONG_TO_SHORT = new Utils.Function<Object, Object>(){

        @Override
        public Short apply(Object in) {
            return ((Long)in).shortValue();
        }
    };
    private static final Utils.Function<Object, Object> LONG_TO_BYTE = new Utils.Function<Object, Object>(){

        @Override
        public Byte apply(Object in) {
            return ((Long)in).byteValue();
        }
    };
    private static final Utils.Function<Object, Object> LONG_TO_CHARACTER = new Utils.Function<Object, Object>(){

        @Override
        public Character apply(Object in) {
            return Character.valueOf((char)((Long)in).longValue());
        }
    };
    private static final Utils.Function<Object, Object> DOUBLE_TO_FLOAT = new Utils.Function<Object, Object>(){

        @Override
        public Float apply(Object in) {
            return Float.valueOf(((Double)in).floatValue());
        }
    };
    private static final Utils.Function<Object, Object> DOUBLE_TO_BIG_DECIMAL = new Utils.Function<Object, Object>(){

        @Override
        public BigDecimal apply(Object in) {
            return new BigDecimal((Double)in);
        }
    };
    private static final Utils.Function<Object, Object> INTEGER_TO_LONG = new Utils.Function<Object, Object>(){

        @Override
        public Long apply(Object in) {
            return ((Integer)in).longValue();
        }
    };
    private static final Utils.Function<Object, Object> SHORT_TO_LONG = new Utils.Function<Object, Object>(){

        @Override
        public Long apply(Object in) {
            return ((Short)in).longValue();
        }
    };
    private static final Utils.Function<Object, Object> CHARACTER_TO_LONG = new Utils.Function<Object, Object>(){

        @Override
        public Long apply(Object character) {
            return ((Character)character).charValue();
        }
    };
    private static final Utils.Function<Object, Object> BYTE_TO_LONG = new Utils.Function<Object, Object>(){

        @Override
        public Long apply(Object in) {
            return ((Byte)in).longValue();
        }
    };
    private static final Utils.Function<Object, Object> FLOAT_TO_DOUBLE = new Utils.Function<Object, Object>(){

        @Override
        public Double apply(Object in) {
            return ((Float)in).doubleValue();
        }
    };
    private static final Utils.Function<Object, Object> BIG_DECIMAL_TO_DOUBLE = new Utils.Function<Object, Object>(){

        @Override
        public Double apply(Object in) {
            return ((BigDecimal)in).doubleValue();
        }
    };
    private static final Map<Class<?>, Utils.Function<Object, Object>> DATASTORE_TO_POJO_TYPE_FUNC = TypeConversionUtils.buildDatastoreToPojoTypeFuncMap();
    private static final Map<Class<?>, Utils.Function<Object, Object>> POJO_TO_DATASTORE_TYPE_FUNC = TypeConversionUtils.buildPojoToDatastoreTypeFuncMap();
    private static Utils.Function<Object, Object> IDENTITY = new Utils.Function<Object, Object>(){

        @Override
        public Object apply(Object from) {
            return from;
        }
    };

    TypeConversionUtils() {
    }

    private static Map<Class<?>, Utils.Function<Object, Object>> buildDatastoreToPojoTypeFuncMap() {
        HashMap map = new HashMap();
        map.put(Integer.class, LONG_TO_INTEGER);
        map.put(Integer.TYPE, LONG_TO_INTEGER);
        map.put(Short.class, LONG_TO_SHORT);
        map.put(Short.TYPE, LONG_TO_SHORT);
        map.put(Byte.class, LONG_TO_BYTE);
        map.put(Byte.TYPE, LONG_TO_BYTE);
        map.put(Character.class, LONG_TO_CHARACTER);
        map.put(Character.TYPE, LONG_TO_CHARACTER);
        map.put(Float.class, DOUBLE_TO_FLOAT);
        map.put(Float.TYPE, DOUBLE_TO_FLOAT);
        map.put(BigDecimal.class, DOUBLE_TO_BIG_DECIMAL);
        return map;
    }

    private static Map<Class<?>, Utils.Function<Object, Object>> buildPojoToDatastoreTypeFuncMap() {
        HashMap map = new HashMap();
        map.put(Integer.class, INTEGER_TO_LONG);
        map.put(Integer.TYPE, INTEGER_TO_LONG);
        map.put(Short.class, SHORT_TO_LONG);
        map.put(Short.TYPE, SHORT_TO_LONG);
        map.put(Byte.class, BYTE_TO_LONG);
        map.put(Byte.TYPE, BYTE_TO_LONG);
        map.put(Character.class, CHARACTER_TO_LONG);
        map.put(Character.TYPE, CHARACTER_TO_LONG);
        map.put(Float.class, FLOAT_TO_DOUBLE);
        map.put(Float.TYPE, FLOAT_TO_DOUBLE);
        map.put(BigDecimal.class, BIG_DECIMAL_TO_DOUBLE);
        return map;
    }

    private boolean pojoPropertyIsByteArray(AbstractMemberMetaData metaData) {
        Class<?> componentType = metaData.getType().getComponentType();
        return componentType.equals(Byte.class) || componentType.equals(Byte.TYPE);
    }

    private boolean pojoPropertyIsByteCollection(AbstractMemberMetaData metaData) {
        ContainerMetaData cmd = metaData.getContainer();
        String containerClassStr = ((CollectionMetaData)cmd).getElementType();
        return containerClassStr.equals(Byte.class.getName()) || containerClassStr.equals(Byte.TYPE.getName());
    }

    private ShortBlob convertByteArrayToShortBlob(Object value) {
        if (value.getClass().getComponentType().isPrimitive()) {
            return new ShortBlob((byte[])value);
        }
        return this.convertByteCollectionToShortBlob(Arrays.asList((Byte[])value));
    }

    private ShortBlob convertByteCollectionToShortBlob(Collection<Byte> value) {
        return new ShortBlob(PrimitiveArrays.toByteArray(value));
    }

    private List<?> convertPojoArrayToDatastoreList(Object value) {
        Class<?> componentType = value.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            List<Object> datastoreList = PrimitiveUtils.PRIMITIVE_ARRAY_TO_LIST_FUNC_MAP.get(componentType).apply(value);
            if (POJO_TO_DATASTORE_TYPE_FUNC.get(componentType) != null) {
                datastoreList = Utils.transform(datastoreList, POJO_TO_DATASTORE_TYPE_FUNC.get(componentType));
            }
            return datastoreList;
        }
        return this.convertNonPrimitivePojoArrayToDatastoreList((Object[])value);
    }

    private List<?> convertNonPrimitivePojoArrayToDatastoreList(Object[] array) {
        List<Object> datastoreList = Arrays.asList(array);
        if (POJO_TO_DATASTORE_TYPE_FUNC.get(array.getClass().getComponentType()) != null) {
            datastoreList = Utils.transform(Arrays.asList(array), POJO_TO_DATASTORE_TYPE_FUNC.get(array.getClass().getComponentType()));
        }
        return datastoreList;
    }

    Object datastoreValueToPojoValue(ClassLoaderResolver clr, Object value, StateManager ownerSM, AbstractMemberMetaData ammd) {
        ContainerMetaData cmd = ammd.getContainer();
        if (this.pojoPropertyIsArray(ammd)) {
            value = this.datastoreValueToPojoArray(value, ammd);
        } else if (this.pojoPropertyIsCollection(cmd)) {
            value = this.datastoreValueToPojoCollection(clr, value, ownerSM, ammd, cmd);
        } else if (value != null) {
            value = this.getDatastoreToPojoTypeFunc(Utils.<Object>identity(), ammd).apply(value);
        }
        return value;
    }

    private Object datastoreValueToPojoCollection(ClassLoaderResolver clr, Object value, StateManager ownerSM, AbstractMemberMetaData ammd, ContainerMetaData cmd) {
        CollectionMetaData collMetaData = (CollectionMetaData)cmd;
        String memberTypeStr = collMetaData.getElementType();
        Class<?> memberType = this.classForName(clr, memberTypeStr);
        Utils.Function<Object, Object> conversionFunc = DATASTORE_TO_POJO_TYPE_FUNC.get(memberType);
        if (value instanceof ShortBlob) {
            if (!memberType.equals(Byte.TYPE) && !memberType.equals(Byte.class)) {
                throw new NucleusException("Cannot convert a ShortBlob to an array of type " + memberType.getName());
            }
            value = Arrays.asList((Byte[])this.convertShortBlobToByteArray((ShortBlob)value, memberType));
            conversionFunc = null;
        }
        List datastoreList = value;
        if (this.pojoPropertyIsSet(ammd)) {
            Class setType = ammd.getType();
            value = this.convertDatastoreListToPojoSet(datastoreList, memberType, setType, conversionFunc);
        } else if (this.pojoPropertyIsCollection(ammd)) {
            Class listType = ammd.getType();
            value = this.convertDatastoreListToPojoCollection(datastoreList, memberType, listType, conversionFunc);
        }
        return this.wrap(ownerSM, ammd, value);
    }

    private Object datastoreValueToPojoArray(Object value, AbstractMemberMetaData ammd) {
        Class<?> memberType = ammd.getType().getComponentType();
        if (value instanceof ShortBlob) {
            if (!memberType.equals(Byte.TYPE) && !memberType.equals(Byte.class)) {
                throw new NucleusException("Cannot convert a ShortBlob to an array of type " + memberType.getName());
            }
            value = this.convertShortBlobToByteArray((ShortBlob)value, memberType);
        } else {
            List datastoreList = (List)value;
            value = this.convertDatastoreListToPojoArray(datastoreList, memberType);
        }
        return value;
    }

    Object wrap(StateManager ownerSM, AbstractMemberMetaData ammd, Object value) {
        return SCOUtils.newSCOInstance((StateManager)ownerSM, (AbstractMemberMetaData)ammd, (Class)ammd.getType(), value.getClass(), (Object)value, (boolean)false, (boolean)false, (boolean)true);
    }

    private Object convertShortBlobToByteArray(ShortBlob shortBlob, Class<?> pojoType) {
        if (pojoType.isPrimitive()) {
            return shortBlob.getBytes();
        }
        byte[] bytes = shortBlob.getBytes();
        Byte[] array = (Byte[])Array.newInstance(pojoType, bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            array[i] = bytes[i];
        }
        return array;
    }

    private Collection<Object> newCollection(Class<? extends Collection> collType) {
        Collection<Object> collToReturn;
        if (collType.isInterface()) {
            collToReturn = Utils.newArrayList(new Object[0]);
        } else {
            try {
                collToReturn = collType.newInstance();
            }
            catch (InstantiationException e) {
                throw new NucleusException("Cannot instantiate Collection of type " + collType.getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new NucleusException("Cannot instantiate Collection of type " + collType.getName(), (Throwable)e);
            }
        }
        return collToReturn;
    }

    Collection<Object> convertDatastoreListToPojoCollection(List<Object> datastoreList, Class<?> pojoType, Class<? extends Collection> collType) {
        Utils.Function<Object, Object> func = DATASTORE_TO_POJO_TYPE_FUNC.get(pojoType);
        return this.convertDatastoreListToPojoCollection(datastoreList, pojoType, collType, func);
    }

    Collection<Object> convertDatastoreListToPojoCollection(List<Object> datastoreList, Class<?> pojoType, Class<? extends Collection> collType, Utils.Function<Object, Object> func) {
        Collection<Object> listToReturn = this.newCollection(collType);
        if (datastoreList == null) {
            return listToReturn;
        }
        if (func != null) {
            datastoreList = Utils.transform(datastoreList, func);
        } else if (Enum.class.isAssignableFrom(pojoType)) {
            Class<Enum> enumClass = pojoType;
            datastoreList = new ArrayList<Object>(Arrays.asList(this.convertStringListToEnumArray(datastoreList, enumClass)));
        }
        if (collType.isAssignableFrom(datastoreList.getClass())) {
            return datastoreList;
        }
        listToReturn.addAll(datastoreList);
        return listToReturn;
    }

    private Set<Object> newSet(Class<? extends Set> setType) {
        Set<Object> setToReturn;
        if (Set.class.equals(setType)) {
            setToReturn = Utils.newHashSet(new Object[0]);
        } else if (SortedSet.class.equals(setType)) {
            setToReturn = Utils.newTreeSet(new Object[0]);
        } else {
            try {
                setToReturn = setType.newInstance();
            }
            catch (InstantiationException e) {
                throw new NucleusException("Cannot instantiate Set of type " + setType.getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new NucleusException("Cannot instantiate Set of type " + setType.getName(), (Throwable)e);
            }
        }
        return setToReturn;
    }

    Set<Object> convertDatastoreListToPojoSet(List<Object> datastoreList, Class<?> pojoType, Class<? extends Set> setType, Utils.Function<Object, Object> conversionFunc) {
        Collection<Object> convertedList = this.convertDatastoreListToPojoCollection(datastoreList, pojoType, ArrayList.class, conversionFunc);
        Set<Object> setToReturn = this.newSet(setType);
        setToReturn.addAll(convertedList);
        return setToReturn;
    }

    Object convertDatastoreListToPojoArray(List<Object> datastoreList, Class<?> pojoType) {
        Collection<Object> datastoreColl = this.convertDatastoreListToPojoCollection(datastoreList, pojoType, ArrayList.class);
        if (pojoType.isPrimitive()) {
            return PrimitiveUtils.COLLECTION_TO_PRIMITIVE_ARRAY_FUNC_MAP.get(pojoType).apply(datastoreColl);
        }
        Object[] array = (Object[])Array.newInstance(pojoType, datastoreColl.size());
        return datastoreColl.toArray(array);
    }

    private Object[] convertStringListToEnumArray(List<?> datastoreList, Class<Enum> pojoType) {
        Object[] result = (Object[])Array.newInstance(pojoType, datastoreList.size());
        int i = 0;
        for (Object obj : datastoreList) {
            result[i++] = obj == null ? null : Enum.valueOf(pojoType, (String)obj);
        }
        return result;
    }

    private Class<?> classForName(ClassLoaderResolver clr, String typeStr) {
        Class clazz = PrimitiveUtils.PRIMITIVE_CLASSNAMES.get(typeStr);
        if (clazz == null) {
            clazz = clr.classForName(typeStr);
        }
        return clazz;
    }

    private Utils.Function<Object, Object> getDatastoreToPojoTypeFunc(Utils.Function<Object, Object> defaultVal, AbstractMemberMetaData ammd) {
        Utils.Function<Object, Object> candidate = DATASTORE_TO_POJO_TYPE_FUNC.get(ammd.getType());
        return candidate != null ? candidate : defaultVal;
    }

    private Utils.Function<Object, Object> getPojoToDatastoreTypeFunc(Utils.Function<Object, Object> defaultVal, AbstractMemberMetaData ammd) {
        Utils.Function<Object, Object> candidate = POJO_TO_DATASTORE_TYPE_FUNC.get(ammd.getType());
        return candidate != null ? candidate : defaultVal;
    }

    private boolean pojoPropertyIsCollection(ContainerMetaData cmd) {
        return cmd instanceof CollectionMetaData;
    }

    private boolean pojoPropertyIsSet(AbstractMemberMetaData ammd) {
        return Set.class.isAssignableFrom(ammd.getType());
    }

    private boolean pojoPropertyIsCollection(AbstractMemberMetaData ammd) {
        return Collection.class.isAssignableFrom(ammd.getType());
    }

    private boolean pojoPropertyIsArray(AbstractMemberMetaData ammd) {
        return ammd.getContainer() instanceof ArrayMetaData;
    }

    private List<String> convertEnumsToStringList(Iterable<Enum> enums) {
        ArrayList<Object> result = Utils.newArrayList(new Object[0]);
        for (Enum e : enums) {
            result.add(e == null ? null : e.name());
        }
        return result;
    }

    Object pojoValueToDatastoreValue(ClassLoaderResolver clr, Object value, AbstractMemberMetaData ammd) {
        if (this.pojoPropertyIsArray(ammd)) {
            value = this.convertPojoArrayToDatastoreValue(ammd, value);
        } else if (this.pojoPropertyIsCollection(ammd.getContainer())) {
            value = this.convertPojoCollectionToDatastoreValue(clr, ammd, (Collection)value);
        } else if (value != null) {
            value = this.getPojoToDatastoreTypeFunc(Utils.<Object>identity(), ammd).apply(value);
        }
        return value;
    }

    private Object convertPojoCollectionToDatastoreValue(ClassLoaderResolver clr, AbstractMemberMetaData ammd, Collection<?> value) {
        Object result = value;
        Class elementType = clr.classForName(ammd.getCollection().getElementType());
        if (Enum.class.isAssignableFrom(elementType)) {
            ShortBlob enums = value;
            result = this.convertEnumsToStringList((Iterable<Enum>)enums);
        } else if (this.pojoPropertyIsByteCollection(ammd)) {
            result = this.convertByteCollectionToShortBlob((Collection<Byte>)value);
        } else if (POJO_TO_DATASTORE_TYPE_FUNC.get(elementType) != null) {
            result = Utils.transform(value, POJO_TO_DATASTORE_TYPE_FUNC.get(elementType));
        } else if (!(value instanceof List)) {
            result = Utils.transform(value, IDENTITY);
        }
        return result;
    }

    private Object convertPojoArrayToDatastoreValue(AbstractMemberMetaData ammd, Object value) {
        Object result = this.pojoPropertyIsByteArray(ammd) ? this.convertByteArrayToShortBlob(value) : (Enum.class.isAssignableFrom(ammd.getType().getComponentType()) ? this.convertEnumsToStringList(Arrays.asList((Enum[])value)) : this.convertPojoArrayToDatastoreList(value));
        return result;
    }
}

