/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Transaction;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionCleanupFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(TransactionCleanupFilter.class.getName());
    private DatastoreService datastoreService;

    public void init(FilterConfig filterConfig) {
        this.datastoreService = this.getDatastoreService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            Collection<Transaction> txns = this.datastoreService.getActiveTransactions();
            if (!txns.isEmpty()) {
                this.handleAbandonedTxns(txns);
            }
        }
    }

    void handleAbandonedTxns(Collection<Transaction> txns) {
        for (Transaction txn : txns) {
            try {
                logger.warning("Request completed without committing or rolling back transaction with id " + txn.getId() + ".  Transaction will be rolled back.");
                txn.rollback();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Swallowing an exception we received while trying to rollback abandoned transaction with id " + txn.getId(), e);
            }
        }
    }

    public void destroy() {
        this.datastoreService = null;
    }

    DatastoreService getDatastoreService() {
        return DatastoreServiceFactory.getDatastoreService();
    }
}

