/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.string;

import org.springmodules.validation.util.condition.string.AbstractStringCondition;

public class LengthRangeStringCondition
extends AbstractStringCondition {
    private int minLength;
    private int maxLength;

    public LengthRangeStringCondition(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    protected boolean checkString(String text) {
        int length = text.length();
        return length >= this.minLength && length <= this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }
}

