/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.xml.handler;

import java.math.BigDecimal;
import org.springframework.util.StringUtils;
import org.springmodules.validation.bean.conf.ValidationConfigurationException;
import org.springmodules.validation.bean.conf.loader.xml.handler.AbstractPropertyValidationElementHandler;
import org.springmodules.validation.bean.rule.AbstractValidationRule;
import org.springmodules.validation.bean.rule.MaxValidationRule;
import org.springmodules.validation.bean.rule.MinValidationRule;
import org.springmodules.validation.bean.rule.RangeValidationRule;
import org.w3c.dom.Element;

public class RangeRuleElementHandler
extends AbstractPropertyValidationElementHandler {
    public static final String DEFAULT_MIN_ERROR_CODE = "range";
    public static final String DEFAULT_MAX_ERROR_CODE = "range";
    private static final String ELEMENT_NAME = "range";
    private static final String MIN_ATTR = "min";
    private static final String MAX_ATTR = "max";

    public RangeRuleElementHandler(String namespaceUri) {
        super("range", namespaceUri);
    }

    protected AbstractValidationRule createValidationRule(Element element) {
        BigDecimal max;
        String minText = element.getAttribute(MIN_ATTR);
        String maxText = element.getAttribute(MAX_ATTR);
        BigDecimal min = StringUtils.hasText((String)minText) ? new BigDecimal(minText) : null;
        BigDecimal bigDecimal = max = StringUtils.hasText((String)maxText) ? new BigDecimal(maxText) : null;
        if (min != null && max != null) {
            return new RangeValidationRule(min, max);
        }
        if (min != null) {
            return new MinValidationRule(min);
        }
        if (max != null) {
            return new MaxValidationRule(max);
        }
        throw new ValidationConfigurationException("Element 'range' must have either 'min' attribute, 'max' attribute, or both");
    }
}

