/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.MemcacheServiceException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogAndContinueErrorHandler
implements ErrorHandler {
    private final Level level;
    private final Logger logger;

    public LogAndContinueErrorHandler(Level level) {
        this.level = level;
        this.logger = Logger.getLogger(LogAndContinueErrorHandler.class.getName());
    }

    public void handleDeserializationError(InvalidValueException thrown) {
        this.logger.log(this.level, "Deserialization error in memcache", thrown);
    }

    public void handleServiceError(MemcacheServiceException thrown) {
        this.logger.log(this.level, "Service error in memcache", thrown);
    }
}

