/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.NullMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;

public class ReferenceExpression
extends ScalarExpression {
    public ReferenceExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public ScalarExpression cast(Class castType) {
        JavaTypeMapping[] javaTypeMappings = ((ReferenceMapping)this.mapping).getJavaTypeMapping();
        for (int i = 0; i < javaTypeMappings.length; ++i) {
            JavaTypeMapping m = javaTypeMappings[i];
            if (!castType.getName().equals(m.getType())) continue;
            return m.newScalarExpression(this.qs, this.te);
        }
        return super.cast(castType);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        ScalarExpression bexpr = null;
        JavaTypeMapping[] javaTypeMappings = ((ReferenceMapping)this.mapping).getJavaTypeMapping();
        if (expr.mapping instanceof ReferenceMapping) {
            for (int i = 0; i < javaTypeMappings.length; ++i) {
                JavaTypeMapping m = javaTypeMappings[i];
                if (bexpr == null) {
                    bexpr = m.newScalarExpression(this.qs, this.te).eq(expr);
                    bexpr.encloseWithInParentheses();
                    continue;
                }
                bexpr = ((BooleanExpression)bexpr).ior(m.newScalarExpression(this.qs, this.te).eq(expr).encloseWithInParentheses());
                bexpr.encloseWithInParentheses();
            }
        } else if (expr.mapping instanceof NullMapping) {
            for (int i = 0; i < javaTypeMappings.length; ++i) {
                JavaTypeMapping m = javaTypeMappings[i];
                bexpr = bexpr == null ? m.newScalarExpression(this.qs, this.te).eq(expr) : ((BooleanExpression)bexpr).and(m.newScalarExpression(this.qs, this.te).eq(expr));
            }
        } else {
            for (int i = 0; i < javaTypeMappings.length; ++i) {
                JavaTypeMapping m = javaTypeMappings[i];
                JavaTypeMapping exprMapping = expr.mapping;
                if (m.getNumberOfDatastoreFields() != exprMapping.getNumberOfDatastoreFields()) continue;
                if (bexpr == null) {
                    bexpr = m.newScalarExpression(this.qs, this.te).eq(expr);
                    bexpr.encloseWithInParentheses();
                    continue;
                }
                bexpr = ((BooleanExpression)bexpr).ior(m.newScalarExpression(this.qs, this.te).eq(expr).encloseWithInParentheses());
                bexpr.encloseWithInParentheses();
            }
        }
        bexpr.encloseWithInParentheses();
        return bexpr;
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        ScalarExpression bexpr = null;
        JavaTypeMapping[] javaTypeMappings = ((ReferenceMapping)this.mapping).getJavaTypeMapping();
        if (expr.mapping instanceof NullMapping) {
            for (int i = 0; i < javaTypeMappings.length; ++i) {
                JavaTypeMapping m = javaTypeMappings[i];
                bexpr = bexpr == null ? m.newScalarExpression(this.qs, this.te).noteq(expr) : ((BooleanExpression)bexpr).ior(m.newScalarExpression(this.qs, this.te).noteq(expr));
            }
        } else {
            for (int i = 0; i < javaTypeMappings.length; ++i) {
                JavaTypeMapping m = javaTypeMappings[i];
                bexpr = bexpr == null ? m.newScalarExpression(this.qs, this.te).noteq(expr) : ((BooleanExpression)bexpr).and(m.newScalarExpression(this.qs, this.te).noteq(expr));
            }
        }
        bexpr.encloseWithInParentheses();
        return bexpr;
    }

    public ScalarExpression accessField(String fieldName, boolean innerJoin) {
        throw new NucleusUserException(LOCALISER.msg("037000", (Object)fieldName, (Object)this.mapping.getType()));
    }
}

