package com.jispot.web;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.jispot.domain.model.Spotter;
import com.jispot.services.ConnectionService;

@Controller("loginController")
public class LoginController extends JISpotAjaxController {

	protected final Logger log = Logger.getLogger(this.getClass().getName());

	@Autowired
	private ConnectionService connectionService;

	/**
	 * Affiche la page de login -> home page now
	 */
	@RequestMapping(value = "/login.html", method = RequestMethod.GET)
	public String login() {
		log.info("LoginController.login called !");
		return "index";
	}

	/**
	 * Handler de la methode Get pour l'URL /login-standart.html.
	 * 
	 * @param model
	 *            Une map des donnees qui sont utilisables dans la vue
	 * @return <code>home</code> La page de redirection : /WEB-INF/jsp/home.jsp.
	 */
	@RequestMapping(value = "/login.html", method = RequestMethod.POST)
	public void login(
			HttpServletRequest request,
			HttpServletResponse response,
			@RequestParam(value = "login", required = false) final String email,
			@RequestParam(value = "password", required = false) final String password) {

		super.init(request, response);

		log.info("LoginAjaxController.login called!");
		log.info("email    = " + email);
		log.info("password = " + password);

		Map<String, String> resultMap = new HashMap<String, String>();
		Spotter spotter = connectionService.login(email, password);
		if (spotter != null) {
			log.info("Connexion OK");
			// Get the data
			resultMap.put("result", "OK");
			resultMap.put("message", "Log In OK!");
			session.setAttribute("USER_LOGIN", spotter.id);
		} else {
			log.info("Connexion KO");
			resultMap.put("result", "KO");
			resultMap.put("message", "Log In KO!");
		}

		super.sendJsonResult(resultMap);
	}

}
