/*
 * Decompiled with CFR 0.152.
 */
package siena.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import siena.SienaException;
import siena.jdbc.ConnectionManager;
import siena.logging.SienaLogger;
import siena.logging.SienaLoggerFactory;

public abstract class AbstractConnectionManager
implements ConnectionManager {
    protected static SienaLogger logger = SienaLoggerFactory.getLogger(AbstractConnectionManager.class);

    @Override
    public void beginTransaction(int isolationLevel) {
        try {
            Connection c = this.getConnection();
            c.setAutoCommit(false);
            c.setTransactionIsolation(isolationLevel);
        }
        catch (SQLException e) {
            logger.severe(e, e);
            throw new SienaException(e);
        }
    }

    @Override
    public void commitTransaction() {
        try {
            Connection c = this.getConnection();
            c.commit();
        }
        catch (SQLException e) {
            logger.severe(e, e);
            throw new SienaException(e);
        }
    }

    @Override
    public void rollbackTransaction() {
        try {
            Connection c = this.getConnection();
            c.rollback();
        }
        catch (SQLException e) {
            logger.severe(e, e);
            throw new SienaException(e);
        }
    }
}

