package com.jispot.common;

import java.util.Iterator;
import java.util.List;

public class JISpotErrorMappingProperties extends PropertyFile {

    // ***********************************************************************

    private static JISpotErrorMappingProperties instance = new JISpotErrorMappingProperties();

    public static JISpotErrorMappingProperties getInstance() {
        return instance;
    }

    public JISpotErrorMappingProperties() {
        init( "/jispot-mapping-http-error.properties" );
    }

    // ***********************************************************************

    public static int getHttpCodeForError( int errorCode ) {
        Iterator<Object> ite = instance.props.keySet().iterator();
        while ( ite.hasNext() ) {
            String key = ( String ) ite.next();
            List<String> list = instance.getListeSimple( key );
            if ( list != null && list.contains( String.valueOf( errorCode ) ) ) {
                return Integer.parseInt( key );
            }
        }
        return instance.getAsInt( "default.code" );
    }

}
