/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.images.ImagesServicePb;
import com.google.appengine.api.images.Transform;

final class Crop
extends Transform {
    private static final long serialVersionUID = -5386318194508610219L;
    private final float leftX;
    private final float topY;
    private final float rightX;
    private final float bottomY;

    Crop(float leftX, float topY, float rightX, float bottomY) {
        this.checkCropArgument(leftX);
        this.checkCropArgument(topY);
        this.checkCropArgument(rightX);
        this.checkCropArgument(bottomY);
        if (leftX >= rightX) {
            throw new IllegalArgumentException("leftX must be < rightX");
        }
        if (topY >= bottomY) {
            throw new IllegalArgumentException("topY must be < bottomY");
        }
        this.leftX = leftX;
        this.topY = topY;
        this.rightX = rightX;
        this.bottomY = bottomY;
    }

    void apply(ImagesServicePb.ImagesTransformRequest.Builder request) {
        request.addTransform(ImagesServicePb.Transform.newBuilder().setCropLeftX(this.leftX).setCropTopY(this.topY).setCropRightX(this.rightX).setCropBottomY(this.bottomY));
    }

    private void checkCropArgument(float arg) {
        if ((double)arg < 0.0) {
            throw new IllegalArgumentException("Crop arguments must be >= 0");
        }
        if ((double)arg > 1.0) {
            throw new IllegalArgumentException("Crop arguments must be <= 1");
        }
    }
}

