/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AbstractLinkedIterator;
import com.google.appengine.repackaged.com.google.common.collect.DiscreteDomain;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.appengine.repackaged.com.google.common.collect.ObjectArrays;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import com.google.appengine.repackaged.com.google.common.collect.Range;
import com.google.appengine.repackaged.com.google.common.collect.Ranges;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
final class ContiguousSet<C extends Comparable>
extends ImmutableSortedSet<C> {
    private final Range<C> range;
    private final DiscreteDomain<C> domain;
    private static final long serialVersionUID = 0L;

    ContiguousSet(Range<C> range, DiscreteDomain<C> domain) {
        super(Ordering.natural());
        this.range = range;
        this.domain = domain;
    }

    @Override
    public ImmutableSortedSet<C> headSet(C toElement) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(toElement)));
    }

    @Override
    ImmutableSortedSet<C> headSetImpl(C toElement) {
        return this.range.intersection(Ranges.lessThan(toElement)).asSet(this.domain);
    }

    @Override
    int indexOf(Object target) {
        return this.contains(target) ? (int)this.domain.distance((Comparable)this.first(), (Comparable)target) : -1;
    }

    @Override
    public ImmutableSortedSet<C> subSet(C fromElement, C toElement) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator().compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, toElement);
    }

    @Override
    ImmutableSortedSet<C> subSetImpl(C fromElement, C toElement) {
        return this.range.intersection(Ranges.closedOpen(fromElement, toElement)).asSet(this.domain);
    }

    @Override
    public ImmutableSortedSet<C> tailSet(C fromElement) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(fromElement)));
    }

    @Override
    ImmutableSortedSet<C> tailSetImpl(C fromElement) {
        return this.range.intersection(Ranges.atLeast(fromElement)).asSet(this.domain);
    }

    @Override
    public UnmodifiableIterator<C> iterator() {
        return new AbstractLinkedIterator<C>((Comparable)this.first()){
            final C last;
            {
                this.last = ContiguousSet.this.last();
            }

            @Override
            protected C computeNext(C previous) {
                return ContiguousSet.equalsOrThrow(previous, this.last) ? null : (Object)ContiguousSet.this.domain.next(previous);
            }
        };
    }

    private static boolean equalsOrThrow(Comparable<?> left, @Nullable Comparable<?> right) {
        return right != null && ContiguousSet.compareOrThrow(left, right) == 0;
    }

    private static int compareOrThrow(Comparable left, Comparable right) {
        return left.compareTo(right);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public C first() {
        return this.range.lowerBound.leastValueAbove(this.domain);
    }

    @Override
    public C last() {
        return this.range.upperBound.greatestValueBelow(this.domain);
    }

    @Override
    public int size() {
        long distance = this.domain.distance(this.first(), this.last());
        return distance >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)distance + 1;
    }

    @Override
    public boolean contains(Object object) {
        try {
            return this.range.contains((Comparable)object);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> targets) {
        try {
            return this.range.containsAll(targets);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T> T[] toArray(T[] other) {
        return ObjectArrays.toArrayImpl(this, other);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ContiguousSet) {
            ContiguousSet that = (ContiguousSet)object;
            if (this.domain.equals(that.domain)) {
                return this.first().equals(that.first()) && this.last().equals(that.last());
            }
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public String toString() {
        return Ranges.closed(this.first(), this.last()).toString();
    }
}

