/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.xstream;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.XmlMappingException;

abstract class XStreamUtils {
    XStreamUtils() {
    }

    public static XmlMappingException convertXStreamException(Exception ex, boolean marshalling) {
        if (ex instanceof StreamException || ex instanceof CannotResolveClassException || ex instanceof ConversionException) {
            if (marshalling) {
                return new MarshallingFailureException("XStream marshalling exception", ex);
            }
            return new UnmarshallingFailureException("XStream unmarshalling exception", ex);
        }
        return new UncategorizedMappingException("Unknown XStream exception", ex);
    }
}

