/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;

public class ExistsExpression
extends BooleanExpression {
    private final QueryExpression argumentExpression;
    private final boolean truthTest;

    public ExistsExpression(QueryExpression qs, QueryExpression argumentExpression) {
        this(qs, argumentExpression, true);
    }

    public ExistsExpression(QueryExpression qs, QueryExpression argumentExpression, boolean truthTest) {
        super(qs);
        this.argumentExpression = argumentExpression;
        this.truthTest = truthTest;
        if (!truthTest) {
            this.st.append("NOT ");
        }
        argumentExpression.setExistsSubQuery(true);
        this.st.append("EXISTS (").append(argumentExpression).append(')');
    }

    public BooleanExpression not() {
        return new ExistsExpression(this.qs, this.argumentExpression, !this.truthTest);
    }

    public BooleanExpression and(ScalarExpression expr) {
        if (expr instanceof ExistsExpression) {
            ExistsExpression expr2 = (ExistsExpression)expr;
            if (expr2.qs == this.argumentExpression) {
                this.argumentExpression.andCondition(expr2);
                return this;
            }
            if (this.qs == expr2.argumentExpression) {
                expr2.argumentExpression.andCondition(this);
                return expr2;
            }
            return super.and(expr);
        }
        if (expr.qs != this.qs && expr.qs != this.argumentExpression) {
            return super.and(expr);
        }
        this.argumentExpression.andCondition((BooleanExpression)expr, true);
        return this;
    }
}

