/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.Extent;
import org.datanucleus.store.StoreManager;
import org.datanucleus.util.Localiser;

public abstract class AbstractExtent
implements Extent {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected final ObjectManager om;
    protected final Class candidateClass;
    protected final boolean subclasses;
    protected final AbstractClassMetaData cmd;
    protected final StoreManager storeMgr;

    public AbstractExtent(ObjectManager om, Class cls, boolean subclasses, AbstractClassMetaData cmd) {
        if (cls == null) {
            throw new NucleusUserException(LOCALISER.msg("033000")).setFatal();
        }
        this.storeMgr = om.getStoreManager();
        this.cmd = cmd;
        if (cmd == null) {
            throw new NucleusUserException(LOCALISER.msg("033001", (Object)cls.getName())).setFatal();
        }
        this.om = om;
        this.candidateClass = cls;
        this.subclasses = subclasses;
    }

    public boolean hasSubclasses() {
        return this.subclasses;
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public ObjectManager getObjectManager() {
        return this.om;
    }

    public String toString() {
        return LOCALISER.msg("033002", (Object)this.candidateClass.getName(), (Object)("" + this.subclasses));
    }
}

