/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import java.util.List;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.util.Localiser;

public class StringTrimLeftMethodEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        String method = expr.getOperation();
        List args = expr.getArguments();
        char trimChar = ' ';
        if (args != null) {
            trimChar = ((Character)args.get(0)).charValue();
        }
        if (invokedValue == null) {
            return null;
        }
        if (!(invokedValue instanceof String)) {
            throw new NucleusException(LOCALISER.msg("021011", (Object)method, (Object)invokedValue.getClass().getName()));
        }
        String strValue = (String)invokedValue;
        int substringPos = 0;
        for (int i = 0; i < strValue.length() && strValue.charAt(i) == trimChar; ++i) {
            ++substringPos;
        }
        return strValue.substring(substringPos);
    }

    public boolean supportsType(Class cls) {
        if (cls == null) {
            return false;
        }
        return String.class.isAssignableFrom(cls);
    }
}

