package com.jispot.web;

import java.util.logging.Logger;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller("homeController")
public class HomeController {

    protected final Logger log = Logger.getLogger(this.getClass().getName());

    /**
     * Handler de la methode Get pour l'URL /index.html.
     *
     * @param model Une map des donnees qui sont utilisables dans la vue
     * @return <code>home</code> La page de redirection : /WEB-INF/jsp/home.jsp.
     */
    @RequestMapping(value="/index.html", method = RequestMethod.GET)
    public String construction(final ModelMap model) {
    	log.info("HomeController.index called!");
        return "construction";
	}

    /**
     * Handler de la methode Get pour l'URL /index.html.
     *
     * @param model Une map des donnees qui sont utilisables dans la vue
     * @return <code>home</code> La page de redirection : /WEB-INF/jsp/home.jsp.
     */
    @RequestMapping(value="/index2.html", method = RequestMethod.GET)
    public String index(final ModelMap model) {
    	log.info("HomeController.index called!");
        return Constants.PAGE_INDEX;
	}
}
